%------------------------------------------------------------------------------
% File     : SEU997^5 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Set Theory (Relations)
% Problem  : TPS problem CD-LATTICE-THM
% Version  : Especial.
% English  : A complemented distributive lattice has unique complements.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0555 [Bro09]
%          : CD-LATTICE-THM [TPS]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.38 v7.0.0, 0.43 v6.4.0, 0.50 v6.3.0, 0.60 v6.2.0, 0.57 v6.1.0, 0.43 v5.5.0, 0.50 v5.4.0, 0.60 v5.1.0, 0.80 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.0
% Syntax   : Number of formulae    :    2 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :  139 (  21 equality; 118 variable)
%            Maximal formula depth :   26 (  14 average)
%            Number of connectives :   96 (   0   ~;   0   |;  18   &;  76   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    2 (   1   :;   0   =)
%            Number of variables   :   35 (   0 sgn;  34   !;   1   ?;   0   ^)
%                                         (  35   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : Polymorphic definitions expanded.
%          : 
%------------------------------------------------------------------------------
thf(a_type,type,(
    a: $tType )).

thf(cCD_LATTICE_THM_pme,conjecture,(
    ! [JOIN: a > a > a,MEET: a > a > a,TOP: a,BOTTOM: a] :
      ( ( ! [Xx: a] :
            ( ( JOIN @ Xx @ Xx )
            = Xx )
        & ! [Xx: a] :
            ( ( MEET @ Xx @ Xx )
            = Xx )
        & ! [Xx: a,Xy: a,Xz: a] :
            ( ( JOIN @ ( JOIN @ Xx @ Xy ) @ Xz )
            = ( JOIN @ Xx @ ( JOIN @ Xy @ Xz ) ) )
        & ! [Xx: a,Xy: a,Xz: a] :
            ( ( MEET @ ( MEET @ Xx @ Xy ) @ Xz )
            = ( MEET @ Xx @ ( MEET @ Xy @ Xz ) ) )
        & ! [Xx: a,Xy: a] :
            ( ( JOIN @ Xx @ Xy )
            = ( JOIN @ Xy @ Xx ) )
        & ! [Xx: a,Xy: a] :
            ( ( MEET @ Xx @ Xy )
            = ( MEET @ Xy @ Xx ) )
        & ! [Xx: a,Xy: a] :
            ( ( JOIN @ ( MEET @ Xx @ Xy ) @ Xy )
            = Xy )
        & ! [Xx: a,Xy: a] :
            ( ( MEET @ ( JOIN @ Xx @ Xy ) @ Xy )
            = Xy )
        & ! [Xx: a,Xy: a,Xz: a] :
            ( ( MEET @ Xx @ ( JOIN @ Xy @ Xz ) )
            = ( JOIN @ ( MEET @ Xx @ Xy ) @ ( MEET @ Xx @ Xz ) ) )
        & ! [Xx: a,Xy: a,Xz: a] :
            ( ( JOIN @ Xx @ ( MEET @ Xy @ Xz ) )
            = ( MEET @ ( JOIN @ Xx @ Xy ) @ ( JOIN @ Xx @ Xz ) ) )
        & ! [Xx: a] :
            ( ( MEET @ TOP @ Xx )
            = Xx )
        & ! [Xx: a] :
            ( ( JOIN @ TOP @ Xx )
            = TOP )
        & ! [Xx: a] :
            ( ( MEET @ BOTTOM @ Xx )
            = BOTTOM )
        & ! [Xx: a] :
            ( ( JOIN @ BOTTOM @ Xx )
            = Xx )
        & ! [Xx: a] :
          ? [Xy: a] :
            ( ( ( JOIN @ Xx @ Xy )
              = TOP )
            & ( ( MEET @ Xx @ Xy )
              = BOTTOM ) ) )
     => ! [Xx: a,Xy: a,Xz: a] :
          ( ( ( ( JOIN @ Xx @ Xy )
              = TOP )
            & ( ( MEET @ Xx @ Xy )
              = BOTTOM )
            & ( ( JOIN @ Xx @ Xz )
              = TOP )
            & ( ( MEET @ Xx @ Xz )
              = BOTTOM ) )
         => ( Xy = Xz ) ) ) )).

%------------------------------------------------------------------------------
